import React from 'react';
import { InterDataType } from '@/api/interface';
import { GetAppCategoryInfo } from '@/api/interface/mall';
import { MallAPI } from '@/api/modules/mall';
import MallView from '@/components/mall-comp/index';

// 分类列表类型
type CategoryListType = InterDataType<GetAppCategoryInfo>;
// 每次加载页面都会执行
export async function getServerSideProps() {
  // 分类数据
  let categoryList: CategoryListType = [];
  // 获取各个目录及分类信息
  const getAppCategoryInfo = async () => {
    const res = await MallAPI.getAppCategoryInfo({
      type: 4,
    });
    if (res && res.code === '200') {
      categoryList = res?.result || [];
    }
  };
  // 依次获取接口数据
  await (async () => {
    await getAppCategoryInfo();
  })();
  return { props: { categoryList } };
}
const MallMainView: React.FC<{
  categoryList: CategoryListType;
}> = (props) => MallView(props);

export default MallMainView;
